/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.constant.dataticket;

import com.google.common.reflect.TypeToken;
import it.unimi.dsi.fastutil.Pair;
import java.lang.reflect.Type;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;

public final class SerializableDataTicket<D>
extends DataTicket<D> {
    public static final class_9139<class_9129, SerializableDataTicket<?>> STREAM_CODEC = class_9139.method_56434((class_9139)class_2960.field_48267, SerializableDataTicket::getRegisteredId, SerializableDataTicket::enforceValidTicket);
    private final class_9139<? super class_9129, D> streamCodec;
    private final class_2960 registeredId;

    private SerializableDataTicket(class_2960 id, Class<? extends D> objectType, Type dataType, class_9139<? super class_9129, D> streamCodec) {
        super(id.toString(), objectType, dataType);
        this.streamCodec = streamCodec;
        this.registeredId = id;
    }

    public class_2960 getRegisteredId() {
        return this.registeredId;
    }

    public static <D> SerializableDataTicket<D> create(class_2960 id, Class<? extends D> objectType, class_9139<? super class_9129, D> streamCodec) {
        return SerializableDataTicket.create(id, objectType, TypeToken.of(objectType), streamCodec);
    }

    public static <D> SerializableDataTicket<D> create(class_2960 id, Class<? extends D> objectType, TypeToken<D> typeToken, class_9139<? super class_9129, D> streamCodec) {
        return (SerializableDataTicket)IDENTITY_CACHE.computeIfAbsent(Pair.of(objectType, (Object)id.toString()), pair -> DataTickets.registerSerializable(new SerializableDataTicket(id, objectType, typeToken.getType(), streamCodec)));
    }

    public class_9139<? super class_9129, D> streamCodec() {
        return this.streamCodec;
    }

    public static SerializableDataTicket<Double> ofDouble(class_2960 id) {
        return SerializableDataTicket.create(id, Double.class, class_9135.field_48553);
    }

    public static SerializableDataTicket<Float> ofFloat(class_2960 id) {
        return SerializableDataTicket.create(id, Float.class, class_9135.field_48552);
    }

    public static SerializableDataTicket<Boolean> ofBoolean(class_2960 id) {
        return SerializableDataTicket.create(id, Boolean.class, class_9135.field_48547);
    }

    public static SerializableDataTicket<Integer> ofInt(class_2960 id) {
        return SerializableDataTicket.create(id, Integer.class, class_9135.field_49675);
    }

    public static SerializableDataTicket<String> ofString(class_2960 id) {
        return SerializableDataTicket.create(id, String.class, class_9135.field_48554);
    }

    public static <E extends Enum<E>> SerializableDataTicket<E> ofEnum(class_2960 id, final Class<E> enumClass) {
        return SerializableDataTicket.create(id, enumClass, new class_9139<class_9129, E>(){

            public E decode(class_9129 buf) {
                return Enum.valueOf(enumClass, buf.method_19772());
            }

            public void encode(class_9129 buf, E data) {
                buf.method_10814(((Enum)data).toString());
            }
        });
    }

    public static SerializableDataTicket<class_243> ofVec3(class_2960 id) {
        return SerializableDataTicket.create(id, class_243.class, class_9135.field_48558.method_56432(class_243::new, class_243::method_46409));
    }

    public static SerializableDataTicket<class_2338> ofBlockPos(class_2960 id) {
        return SerializableDataTicket.create(id, class_2338.class, new class_9139<class_9129, class_2338>(){

            public class_2338 decode(class_9129 buf) {
                return buf.method_10811();
            }

            public void encode(class_9129 buf, class_2338 blockPos) {
                buf.method_10807(blockPos);
            }
        });
    }

    public static SerializableDataTicket<?> enforceValidTicket(class_2960 name) throws IllegalStateException {
        SerializableDataTicket<?> ticket = DataTickets.byName(name);
        if (ticket == null) {
            throw new IllegalStateException("Attempted to retrieve a SerializableDataTicket that does not exist! Likely didn't register the ticket properly: " + String.valueOf(name));
        }
        return ticket;
    }
}

